#!/usr/bin/env bash
#
#SBATCH --partition=gypsum-1080ti
#SBATCH --gres=gpu:1
#SBATCH --time=03-00:00:00
#SBATCH --mem=16000
#SBATCH --output=outputs/output_%j.out
#SBATCH --cpus-per-task=8

seed=${1:-0}
env_name=${2:-InvertedPendulum-v2}
steps=${3:-2}

echo $seed $env_name $steps

python train_hsp.py --seed $seed --env_name $env_name --automatic_entropy_tuning True --steps $steps --actor_update_frequency 4
exit